#pragma rtGlobals=1		// Use modern global access method.

//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
Proc DoPreTreatmentPanel()
	FilterPanel()
EndMacro

//------------------------------------------------------------------------------------
function KillPreTreatmentPanel()
	DoWindow/K PreTreatmentPanel
end

//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
Function DoFilter_e(PathFolder)
	String PathFolder
	
	SVAR Weight_e=$PathFolder+"OutWaveElec"
	Variable timerRefNum, microSeconds	
	//Print "============= Start Filtering procedures ============="
	timerRefNum = startMSTimer
	Execute("FullFilter_e PreTreatmentParam,"+Weight_e)
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Filter Elapse Time (Sec)=", microSeconds/1e6	
End

//------------------------------------------------------------------------------------
Function DoFilter_i(PathFolder)
	String PathFolder
	
	SVAR Weight_i=$PathFolder+"OutWaveIon"
	Variable timerRefNum, microSeconds	
	
	//Print "============= Start Filtering procedures ============="
	timerRefNum = startMSTimer
	Execute("FullFilter_i PreTreatmentParam,"+Weight_i)
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Filter Elapse Time (Sec)=", microSeconds/1e6
End

//------------------------------------------------------------------------------------
Function DoFilter(PathFolder)
	String PathFolder
	
	SVAR Weight_e=$PathFolder+"OutWaveElec"
	SVAR Weight_i=$PathFolder+"OutWaveIon"
	
	Variable timerRefNum, microSeconds	
	//Print "============= Start Filtering procedures ============="	
	timerRefNum = startMSTimer
	
	Execute("FullFilter PreTreatmentParam,"+Weight_e+","+Weight_i)
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Filter Elapse Time (Sec)=", microSeconds/1e6
End

//------------------------------------------------------------------------------------
Function DoAuto(PathFolder)
	String PathFolder
	
	NVAR AutoFetch=$PathFolder+"AutoFetch"
	NVAR AutoRefresh=$PathFolder+"AutoRefresh"	

	Variable timerRefNum, microSeconds	
	Variable k
	String Command
		
	if (AutoFetch)
		DoFetch_e(PathFolder)
		DoFetch_i(PathFolder) 
	endif

	if (AutoRefresh)
		Execute("RefreshFilterGraph()")
	endif
EndMacro
//------------------------------------------------------------------------------------
Function DoFetch_e(PathFolder)
	String PathFolder
	
	NVAR multi_e=$PathFolder+"Multiplicity_e"
	SVAR Weight_e=$PathFolder+"OutWaveElec"

	NVAR cx_e=$PathFolder+"CenterX_e"
	NVAR cy_e=$PathFolder+"CenterY_e"
	NVAR rot_e=$PathFolder+"Rotation_e"

	Variable timerRefNum, microSeconds
	Variable k
	String Command
	
	timerRefNum = startMSTimer
	Command="Select_wec "+Num2Str(multi_e)+","+Weight_e
	For (k=1;k<=multi_e;k+=1)
			Command+=",t_e"+Num2Str(k)+",x_e"+Num2Str(k)+",y_e"+Num2Str(k)
	Endfor
	Command+=","+Num2Str(cx_e)+","+Num2Str(cy_e)+","+Num2Str(rot_e)+",0"		
	Execute(Command)		
	//print Command
	
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Fetch Electron Elapse Time (Sec)=", microSeconds/1e6
	
End

//------------------------------------------------------------------------------------
Function DoFetch_i(PathFolder)
	String PathFolder
	NVAR multi_i=$PathFolder+"Multiplicity_i"
	SVAR Weight_i=$PathFolder+"OutWaveIon"
	
	NVAR cx_i=$PathFolder+"CenterX_i"
	NVAR cy_i=$PathFolder+"CenterY_i"
	NVAR rot_i=$PathFolder+"Rotation_i"	
	
	Variable timerRefNum, microSeconds
	Variable k
	String Command
	
	timerRefNum = startMSTimer
	Command="Select_wic "+Num2Str(multi_i)+","+Weight_i
	For (k=1;k<=multi_i;k+=1)
			Command+=",t_i"+Num2Str(k)+",x_i"+Num2Str(k)+",y_i"+Num2Str(k)
	Endfor
	Command+=","+Num2Str(cx_i)+","+Num2Str(cy_i)+","+Num2Str(rot_i)+",0"				
	//Execute(Command)		
	//print Command
	
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Fetch Ion Elapse Time (Sec)=", microSeconds/1e6
	
End
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------

Proc DoFilterGraph()
	silent 1
	If (Exists("hist_t_elec")==0)
		RefreshFilterGraph()
	Endif
	DoWindow FilterGraph
	If (V_flag)
		DoWindow/K FilterGraph
	Else		
		FilterGraph()
	Endif
End

//------------------------------------------------------------------------------------

Proc KillFilterGraph()
	silent 1
	DoWindow/K FilterGraph
End

//------------------------------------------------------------------------------------

Proc RefreshFilterGraph()
	
	Variable timerRefNum, microSeconds	
	Silent 1; PauseUpdate;
	timerRefNum = startMSTimer
	
	If (Exists("hist_t_elec")==0)
		print "============= Generate 1rst graph. ============="
		duplicate/O/D t_elec, he; he=1 
		duplicate/O/D t_ions, hi; hi=1 
	Endif

	hist1 t_elec, he,10000,1,10000,0,0,0
	hist1 t_ions, hi,10000,1,10000,0,0,0
	hist2 x_ions,y_ions, hi,64,64,1,64,1,64,0,0,0
	hist2 x_elec,y_elec, he,64,64,1,64,1,64,0,0,0
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Refresh Elapse Time (Sec)=", microSeconds/1e6
End
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------

Proc DoFetchGraph(particle)
	string particle
	silent 1
	DoWindow $("FetchGraph"+particle)
	RefreshFetchGraph(particle)
	If (!(V_flag))
		FetchGraph(particle)
	Endif
End

//------------------------------------------------------------------------------------

Proc KillFetchGraph()
	silent 1
	DoWindow/K FetchGraph
End

//------------------------------------------------------------------------------------

Proc RefreshFetchGraph(particle)
	string particle
	
	Variable timerRefNum, microSeconds	
	Silent 1; PauseUpdate;
	timerRefNum = startMSTimer
	
	duplicate/O/D $("t_"+particle), dummy; dummy=1 
	
	hist2 $("x_"+particle),$("y_"+particle), dummy,64,64,-32,32,-32,32,0,0,0
	killwaves/Z dummy
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Refresh Elapse Time (Sec)=", microSeconds/1e6
End
//------------------------------------------------------------------------------------
